<?php
// access.php
session_start();
require 'db_connection.php'; 

if (!isset($_GET['token']) || empty(trim($_GET['token']))) {
    die("Error: Missing secure access token.");
}

$access_token = htmlspecialchars(trim($_GET['token']));

// Validate Token
$stmt = $pdo->prepare("
    SELECT ds.share_id, ds.recipient_name, ds.recipient_email, ds.status, d.title 
    FROM document_shares ds
    JOIN documents d ON ds.document_id = d.document_id
    WHERE ds.access_token = ? AND ds.status = 'shared'
");
$stmt->execute([$access_token]);
$share_data = $stmt->fetch();

if (!$share_data) {
    die("Security Alert: This link is invalid, expired, or the document has already been processed.");
}

$email = $share_data['recipient_email'];
$name = $share_data['recipient_name'];
$doc_title = $share_data['title'];

// Generate and Save OTP
$otp_code = random_int(100000, 999999);
$expires_at = date('Y-m-d H:i:s', strtotime('+15 minutes'));
$pdo->prepare("INSERT INTO otp_tokens (email, otp_code, expires_at) VALUES (?, ?, ?)")->execute([$email, $otp_code, $expires_at]);

// Dispatch Production OTP Email
$subject = "NCDC Secure Portal - Your Download Code";
$message = "Hello $name,\n\n";
$message .= "You requested access to the document: '$doc_title'.\n\n";
$message .= "Your secure one-time passcode is: $otp_code\n\n";
$message .= "This code will expire in 15 minutes. If you did not request this, please ignore this email.";
$headers = "From: secure-system@ncdc.go.ug\r\n";

mail($email, $subject, $message, $headers);

// Mask email for the UI
$email_parts = explode('@', $email);
$masked_email = substr($email_parts[0], 0, 3) . '***@' . $email_parts[1];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>NCDC | Secure Document Access</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; background-color: #F4F7F9; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; }
        .secure-container { background: white; padding: 40px; border-radius: 8px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); width: 100%; max-width: 400px; text-align: center; border-top: 4px solid #0A5C36; }
        h2 { color: #1E293B; margin-bottom: 10px; font-size: 20px; }
        p { color: #64748B; font-size: 14px; margin-bottom: 24px; line-height: 1.5; }
        .document-name { font-weight: 600; color: #0A5C36; background: #ECFDF5; padding: 4px 8px; border-radius: 4px; display: inline-block; margin-bottom: 10px; }
        input[type="text"] { width: 100%; padding: 12px; border: 1px solid #CBD5E1; border-radius: 6px; font-size: 16px; text-align: center; letter-spacing: 2px; margin-bottom: 20px; box-sizing: border-box; }
        input[type="text"]:focus { outline: none; border-color: #0A5C36; box-shadow: 0 0 0 3px rgba(10, 92, 54, 0.1); }
        .btn-submit { width: 100%; padding: 12px; background: #0A5C36; color: white; border: none; border-radius: 6px; font-size: 14px; font-weight: 600; cursor: pointer; transition: 0.2s; }
        .btn-submit:hover { background: #074729; }
    </style>
</head>
<body>
    <div class="secure-container">
        <h2>Identity Verification Required</h2>
        <div class="document-name"><?php echo htmlspecialchars($doc_title); ?></div>
        <p>For your security, we have just sent a 6-digit access code to <strong><?php echo htmlspecialchars($masked_email); ?></strong>.</p>
        
        <form action="verify_and_download.php" method="POST">
            <input type="text" name="otp_code" placeholder="Enter 6-digit code" required autocomplete="off" maxlength="6">
            <input type="hidden" name="access_token" value="<?php echo htmlspecialchars($access_token); ?>">
            <button type="submit" class="btn-submit">Verify & Download Document</button>
        </form>
    </div>
</body>
</html>